﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using PI.FM.N000.Base.WinForms.Controls;

namespace PI.ZB.N1200.ELearning.WinForms.ExerciseAvatar
{
    public partial class UCTabExerciseAvatarDetails : PI.FM.N000.Base.WinForms.Controls.TabPageContainerControl
    {        
        public UCTabExerciseAvatarDetails()
        {
            InitializeComponent();
            Dock = DockStyle.Fill;
        }

        protected UCExerciseAvatarDetails UCDetails
        {
            get { return (UCExerciseAvatarDetails)base.UCBODetails; }
        }

        protected override void OnInitialize()
        {
            base.OnInitialize();

            _gftpControlImage.Initialize(UCDetails.Environment, UCDetails.Plugin, true);
            _gftpControlImage.FileFilter = Gemini.Dictionary.FileFilters.Picture;
            _gftpControlImage.OnFileChanged += new CM.N214.FTP.WinForms.GFTPControl.FileChangedEventHandler(ImageChanged);
            _gPictureBox.LoadCompleted += new AsyncCompletedEventHandler(ImageLoadCompleted);

            UCDetails.DataManager.Bindings.Add(_gMemoEditText, "Text", _gLabelText);
            UCDetails.DataManager.Bindings.Add(_gComboBoxExerciseType, "ExerciseTypeID", _gLabelExerciseType);
            UCDetails.DataManager.Bindings.Add(_gComboBoxExerciseEvent, "ExerciseEventID", _gLabelExerciseEvent);

            _gComboBoxExerciseType.SetDataSourceEnum<PI.GM.N610.ELearning.BL.Dictionary.Exercise.Types>(PI.GM.N610.ELearning.BL.Dictionary.Text.ExerciseType);
            _gComboBoxExerciseEvent.SetDataSourceEnum<PI.GM.N610.ELearning.BL.Dictionary.Exercise.EventType>(PI.GM.N610.ELearning.BL.Dictionary.Text.ExerciseEvent);
        }

        public override void DoRestore()
        {
            _gftpControlImage.ID = UCDetails.DataManager.Current.ImageFileID;
            if (!String.IsNullOrEmpty(UCDetails.DataManager.Current.ImageFileURL))
            {
                _gPictureBox.Visible = false;
                _gPictureBox.LoadAsync(UCDetails.DataManager.Current.ImageFileURL);
            }
            else
            {
                _gPictureBox.Visible = false;
            }
        }

        public override bool DoSave()
        {
            if (UCDetails.DataManager.Current != null)
            {
                if (_gftpControlImage.IsFileExist)
                {
                    UCDetails.DataManager.Current.ImageFileID = _gftpControlImage.ID;
                    UCDetails.DataManager.Current.ImageFileURL = _gftpControlImage.URL;
                }
                else
                {
                    UCDetails.DataManager.Current.ImageFileID = null;
                    UCDetails.DataManager.Current.ImageFileURL = null;
                }
            }
            return true;
        }

        void ImageLoadCompleted(object sender, AsyncCompletedEventArgs e)
        {
            Gemini.Core.WinForms.Controls.GPictureBox _gPictureBox = sender as Gemini.Core.WinForms.Controls.GPictureBox;

            if (_gPictureBox != null)
            {
                _gPictureBox.Visible = true;
            }

        }

        void ImageChanged()
        {
            if (_gftpControlImage.IsFileExist)
            {
                _gPictureBox.Visible = false;
                _gPictureBox.LoadAsync(_gftpControlImage.URL);
            }
            else
            {
                _gPictureBox.Visible = false;
            }
        }
    }
}
